# Create Implementation Plan

You are tasked with creating a detailed implementation plan for a feature or task.

## Process:

1. **Understand the Requirements**
   - Review all provided information
   - Identify key features and constraints
   - Note any open questions

2. **Analyze the Codebase**
   - Find relevant existing code
   - Understand current architecture
   - Identify integration points

3. **Design the Solution**
   - Outline the technical approach
   - Break down into implementation steps
   - Consider edge cases and error handling

4. **Create the Plan Document**
   - Use clear, structured markdown
   - Include code examples where helpful
   - Provide time estimates if requested

## Plan Structure:

```markdown
# Implementation Plan: [Feature Name]

## Overview
Brief description of what will be implemented

## Requirements
- Requirement 1
- Requirement 2
- Requirement 3

## Technical Approach
High-level description of the solution

## Implementation Steps

### Step 1: [Task Name]
- Description of what needs to be done
- Files to modify or create
- Key considerations

### Step 2: [Task Name]
- Description of what needs to be done
- Files to modify or create
- Key considerations

## Testing Strategy
- Unit tests needed
- Integration tests needed
- Manual testing steps

## Risks and Considerations
- Potential issues
- Performance implications
- Security considerations

## Estimated Timeline
- Step 1: X hours
- Step 2: Y hours
- Testing: Z hours
- Total: N hours
```

## Important:
- Be specific about file changes
- Include concrete examples
- Consider maintenance and scalability
- Think about error handling
- Document assumptions

## Remember:
- Plans should be actionable
- Another developer should be able to implement from your plan
- Include enough detail to avoid ambiguity
- Consider the bigger picture and long-term implications